<?php
/* --------------------------------------------------------------
   ParcelServiceFilters.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\ParcelService\SqlCriteria;

use ArrayIterator;
use Gambio\Core\Criteria\SqlFilters;
use Traversable;

/**
 * Class ParcelServiceFilters
 *
 * @package Gambio\Admin\ParcelService\SqlCriteria
 */
class ParcelServiceFilters implements SqlFilters
{
    /**
     * @var ParcelServiceFilter[]
     */
    private $filters;
    
    
    /**
     * ParcelServiceFilters constructor.
     *
     * @param ParcelServiceFilter ...$filters
     */
    private function __construct(ParcelServiceFilter ...$filters)
    {
        $this->filters = $filters;
    }
    
    
    /**
     * @param ParcelServiceFilter ...$filters
     *
     * @return ParcelServiceFilters
     */
    public static function create(ParcelServiceFilter ...$filters): ParcelServiceFilters
    {
        return new self(...$filters);
    }
    
    
    /**
     * @param ParcelServiceFilter ...$filters
     *
     * @return $this
     */
    public function add(ParcelServiceFilter ...$filters): self
    {
        $this->filters = array_merge($this->filters, $filters);
        
        return $this;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getIterator(): Traversable
    {
        return new ArrayIterator($this->filters);
    }
}